<?php
/********************************************************************************
 MachForm
  
 Copyright 2007-2012 Appnitro Software. This code cannot be redistributed without
 permission from http://www.appnitro.com/
 
 More info at: http://www.appnitro.com/
 ********************************************************************************/
	require('includes/init.php');
	
	require('config.php');
	require('includes/db-core.php');
	require('includes/helper-functions.php');
	require('includes/check-session.php');
	
	require('includes/filter-functions.php');
	require('includes/entry-functions.php');
	require('includes/users-functions.php');

	$form_id = (int) trim($_GET['id']);

	if(!empty($_POST['form_id'])){
		$form_id = (int) $_POST['form_id'];
	}
	
	$dbh = mf_connect_db();
	$mf_settings = mf_get_settings($dbh);

	//check permission, is the user allowed to access this page?
	if(empty($_SESSION['mf_user_privileges']['priv_administer'])){
		$user_perms = mf_get_user_permissions($dbh,$form_id,$_SESSION['mf_user_id']);

		//this page need edit_form permission
		if(empty($user_perms['edit_form'])){
			$_SESSION['MF_DENIED'] = "You don't have permission to edit this form.";

			$ssl_suffix = mf_get_ssl_suffix();						
			header("Location: http{$ssl_suffix}://".$_SERVER['HTTP_HOST'].mf_get_dirname($_SERVER['PHP_SELF'])."/restricted.php");
			exit;
		}
	}

	
	//get form properties
	$query 	= "select 
					form_name,
					form_page_total,
					logic_field_enable,
					logic_page_enable,
					form_review,
					payment_enable_merchant,
					payment_merchant_type
			     from 
			     	 ".MF_TABLE_PREFIX."forms 
			    where 
			    	 form_id = ?";
	$params = array($form_id);
	
	$sth = mf_do_query($query,$params,$dbh);
	$row = mf_do_fetch_result($sth);
	
	if(!empty($row)){
		$form_name 			= htmlspecialchars($row['form_name']);
		$logic_field_enable = (int) $row['logic_field_enable'];
		$logic_page_enable  = (int) $row['logic_page_enable'];
		$form_page_total    = (int) $row['form_page_total'];
		$form_review   		= (int) $row['form_review'];
		$payment_merchant_type = $row['payment_merchant_type'];
		
		$payment_enable_merchant  = (int) $row['payment_enable_merchant'];
		if($payment_enable_merchant < 1){
			$payment_enable_merchant = 0;
		}

		//page logic is only available on multipage form
		if(!empty($logic_page_enable) && $form_page_total <= 1){
			$logic_page_enable = 0;
		}

		$jquery_data_code .= "\$('.logic_settings').data('logic_status',{\"logic_field_enable\": {$logic_field_enable} ,\"logic_page_enable\": {$logic_page_enable}});\n";
	}

	//get the label of all pages within this form
	$all_page_labels = array();
	for ($i=1;$i <= $form_page_total;$i++) { 
		$all_page_labels[$i] = 'Page '.$i;
	}

	if(!empty($form_review)){
		$all_page_labels['review'] = 'Review Page';
	}

	if(!empty($payment_enable_merchant) && $payment_merchant_type != 'check'){
		$all_page_labels['payment'] = 'Payment Page';
	}
	$all_page_labels['success'] = 'Success Page';

	//get the list of all fields within the form (without any child elements)
	$query = "select 
					element_id,
					if(element_type = 'matrix',element_guidelines,element_title) element_title,
					element_type,
					element_page_number,
					element_position
 				from 
 					".MF_TABLE_PREFIX."form_elements 
			   where 
					form_id = ? and 
					element_status = 1 and 
					element_is_private = 0 and 
					element_type <> 'page_break' and 
					element_matrix_parent_id = 0 
		    order by 
		    		element_position asc";
	$params = array($form_id);
	$sth = mf_do_query($query,$params,$dbh);
	
	$all_fields_array = array();
	while($row = mf_do_fetch_result($sth)){
		$element_page_number = (int) $row['element_page_number'];
		$element_id 		 = (int) $row['element_id'];
		$element_position 	 = (int) $row['element_position'] + 1;

		$element_title = htmlspecialchars(strip_tags($row['element_title']));
		
		if(empty($element_title)){
			$element_title = '-untitled field-';
		}

		if(strlen($element_title) > 70){
			$element_title = substr($element_title, 0, 70).'...';
		}											
		

		$all_fields_array[$element_page_number][$element_id]['element_title'] = $element_title." (#{$element_position})";
		$all_fields_array[$element_page_number][$element_id]['element_type']  = $row['element_type'];
	}


	//get a list of all matrix checkboxes ids
	$query = "select 
					element_id,
					element_constraint 
				from 
					".MF_TABLE_PREFIX."form_elements 
			   where 
			   		element_type = 'matrix' and 
			   		element_matrix_parent_id = 0 and 
			   		element_matrix_allow_multiselect = 1 and 
			   		element_status = 1 and 
			   		form_id = ?";
	$params = array($form_id);
	$sth = mf_do_query($query,$params,$dbh);

	$matrix_checkboxes_id_array = array();
	while($row = mf_do_fetch_result($sth)){
		$matrix_checkboxes_id_array[] = $row['element_id'];
		if(!empty($row['element_constraint'])){
			$exploded = array();
			$exploded = explode(',', $row['element_constraint']);
			foreach ($exploded as $value) {
				$matrix_checkboxes_id_array[] = $value;
			}
		}
	}

	//get a list of all time fields and the properties
	$query = "select 
					element_id,
					element_time_showsecond,
					element_time_24hour 
				from 
					".MF_TABLE_PREFIX."form_elements 
			   where 
			   		form_id = ? and 
			   		element_type = 'time' and 
			   		element_status = 1";
	$params = array($form_id);
	$sth = mf_do_query($query,$params,$dbh);

	$time_field_properties = array();
	while($row = mf_do_fetch_result($sth)){
		$time_field_properties[$row['element_id']]['showsecond'] = (int) $row['element_time_showsecond'];
		$time_field_properties[$row['element_id']]['24hour'] 	 = (int) $row['element_time_24hour'];
	}


	//get the list of all fields within the form (including child elements for checkboxes, matrix, etc)
	$columns_meta  = mf_get_columns_meta($dbh,$form_id);
	$columns_label = $columns_meta['name_lookup'];
	$columns_type  = $columns_meta['type_lookup'];

	$field_labels = array_slice($columns_label, 4); //the first four labels are system field. we don't need it.

	//prepare the jquery data for column type lookup
	foreach ($columns_type as $element_name => $element_type) {
		if($element_type == 'matrix'){
			//if this is matrix field which allow multiselect, change the type to checkbox
			$temp = array();
			$temp = explode('_', $element_name);
			$matrix_element_id = $temp[1];

			if(in_array($matrix_element_id, $matrix_checkboxes_id_array)){
				$element_type = 'checkbox';
			}
		}else if($element_type == 'time'){
			//there are several variants of time fields, we need to make it specific
			$temp = array();
			$temp = explode('_', $element_name);
			$time_element_id = $temp[1];

			if(!empty($time_field_properties[$time_element_id]['showsecond']) && !empty($time_field_properties[$time_element_id]['24hour'])){
				$element_type = 'time_showsecond24hour';
			}else if(!empty($time_field_properties[$time_element_id]['showsecond']) && empty($time_field_properties[$time_element_id]['24hour'])){
				$element_type = 'time_showsecond';
			}else if(empty($time_field_properties[$time_element_id]['showsecond']) && !empty($time_field_properties[$time_element_id]['24hour'])){
				$element_type = 'time_24hour';
			}

		}

		$jquery_data_code .= "\$('#ls_fields_lookup').data('$element_name','$element_type');\n";
	}

	/** Field Logic **/
	//get data from ap_field_logic_elements table
	$query = "SELECT 
					A.form_id,
					A.element_id,
					A.rule_show_hide,
					A.rule_all_any,
					B.element_title,
					B.element_position + 1 as element_position,
					B.element_page_number 
				FROM 
					".MF_TABLE_PREFIX."field_logic_elements A LEFT JOIN ".MF_TABLE_PREFIX."form_elements B
				  ON 
				  	A.form_id = B.form_id and A.element_id=B.element_id and B.element_status = 1
			   WHERE
					A.form_id = ?
			ORDER BY 
					B.element_position asc";
	$params = array($form_id);
	$sth = mf_do_query($query,$params,$dbh);
	
	$logic_elements_array = array();
	$all_logic_elements_id = array();

	while($row = mf_do_fetch_result($sth)){
		$element_id = (int) $row['element_id'];
		
		$logic_elements_array[$element_id]['rule_show_hide'] 	= $row['rule_show_hide'];
		$logic_elements_array[$element_id]['rule_all_any'] 		= $row['rule_all_any'];
		$logic_elements_array[$element_id]['element_position'] 	= $row['element_position'];
		$logic_elements_array[$element_id]['element_page_number'] = $row['element_page_number'];

		$element_title = htmlspecialchars(strip_tags($row['element_title']));
		
		if(empty($element_title)){
			$element_title = '-untitled field-';
		}

		if(strlen($element_title) > 70){
			$element_title = substr($element_title, 0, 70).'...';
		}
		$logic_elements_array[$element_id]['element_title'] = $element_title." (#{$row['element_position']})";	

		$all_logic_elements_id[] = $element_id;
	}

	//get data from ap_field_logic_conditions table
	$query = "select target_element_id,element_name,rule_condition,rule_keyword from ".MF_TABLE_PREFIX."field_logic_conditions where form_id = ? order by alc_id asc";
	$params = array($form_id);
	$sth = mf_do_query($query,$params,$dbh);
	
	$logic_conditions_array = array();
	$prev_element_id = 0;

	$i=0;
	while($row = mf_do_fetch_result($sth)){
		$target_element_id = (int) $row['target_element_id'];
		
		if($target_element_id != $prev_element_id){
			$i=0;
		}

		$logic_conditions_array[$target_element_id][$i]['element_name']   = $row['element_name'];
		$logic_conditions_array[$target_element_id][$i]['rule_condition'] = $row['rule_condition'];
		$logic_conditions_array[$target_element_id][$i]['rule_keyword']   = $row['rule_keyword'];

		$prev_element_id = $target_element_id;
		$i++;
	}

	/** Page Logic **/
	//get data from ap_page_logic table
	$query = "SELECT 
					form_id,
					page_id,
					rule_all_any 
				FROM 
					".MF_TABLE_PREFIX."page_logic
			   WHERE
					form_id = ?
			ORDER BY
					page_id ASC";
	$params = array($form_id);
	$sth = mf_do_query($query,$params,$dbh);
	
	$logic_pages_array = array();
	$all_logic_pages_id = array();

	while($row = mf_do_fetch_result($sth)){
		$page_id = $row['page_id'];
		
		$logic_pages_array[$page_id]['rule_all_any'] = $row['rule_all_any'];
		$all_logic_pages_id[] = $page_id;
	}

	//get data from ap_page_logic_conditions table
	$query = "select target_page_id,element_name,rule_condition,rule_keyword from ".MF_TABLE_PREFIX."page_logic_conditions where form_id = ? order by apc_id asc";
	$params = array($form_id);
	$sth = mf_do_query($query,$params,$dbh);
	
	$page_logic_conditions_array = array();
	$prev_page_id = 0;

	$i=0;
	while($row = mf_do_fetch_result($sth)){
		$target_page_id = $row['target_page_id'];
		
		if($target_page_id != $prev_page_id){
			$i=0;
		}

		$page_logic_conditions_array[$target_page_id][$i]['element_name']   = $row['element_name'];
		$page_logic_conditions_array[$target_page_id][$i]['rule_condition'] = $row['rule_condition'];
		$page_logic_conditions_array[$target_page_id][$i]['rule_keyword']   = $row['rule_keyword'];

		$prev_page_id = $target_page_id;
		$i++;
	}


	$header_data =<<<EOT
<link type="text/css" href="js/jquery-ui/themes/base/jquery.ui.all.css" rel="stylesheet" />
<link type="text/css" href="js/datepick/smoothness.datepick.css" rel="stylesheet" />
EOT;

	$current_nav_tab = 'manage_forms';
	require('includes/header.php'); 
	
?>


		<div id="content" class="full">
			<div class="post logic_settings">
				<div class="content_header">
					<div class="content_header_title">
						<div style="float: left">
							<h2><?php echo "<a class=\"breadcrumb\" href='manage_forms.php?id={$form_id}'>".$form_name.'</a>'; ?> <img src="images/icons/resultset_next.gif" /> Logic Builder</h2>
							<p>Define conditions and actions for your form fields or pages</p>
						</div>	
						<div style="float: right;margin-right: 5px">
								<a href="#" id="button_save_logics" name="button_save_logics" class="bb_button bb_small bb_green">
									Save Settings
								</a>
						</div>
						<div style="clear: both; height: 1px"></div>
					</div>
					
				</div>
				<div class="content_body">
					
					<form id="ls_form" method="post" action="<?php echo htmlentities($_SERVER['PHP_SELF']); ?>">
					<ul id="ls_main_list">
						<li>
							<div id="ls_box_field_rules" class="ns_box_main gradient_blue">
								<div class="ns_box_title">
									<input type="checkbox" value="1" class="checkbox" id="logic_field_enable" <?php if(!empty($logic_field_enable)){ echo 'checked="checked"'; } ?> name="logic_field_enable">
									<label for="logic_field_enable" class="choice">Enable Rules to Show/Hide Fields</label>
									<img class="helpmsg" src="images/icons/68_blue.png" style="vertical-align: top" title="Enable this option to show or hide fields on the form based on the value of another fields. Useful for displaying different set of fields based on user choices."/>
								</div>
								<div class="ls_box_content" <?php if(empty($logic_field_enable)){ echo 'style="display: none"'; } ?>>
									<label class="description" for="ls_select_field_rule" style="margin-top: 2px">
										Select a Field to Show/Hide
									</label>
									<select class="select medium" id="ls_select_field_rule" name="ls_select_field_rule" autocomplete="off">
										<option value=""></option>
										<?php
											for ($i=1; $i <= $form_page_total ; $i++) { 
												if($form_page_total > 1){
													echo '<optgroup label="Page '.$i.'">'."\n";
												}

												$current_page_fields = array();
												$current_page_fields = $all_fields_array[$i];
												
												foreach ($current_page_fields as $element_id => $value) {
													if(!empty($all_logic_elements_id)){
														if(in_array($element_id, $all_logic_elements_id)){
															continue;
														}
													}

													$element_title = $value['element_title'];
													echo '<option value="'.$element_id.'">'.$element_title.'</option>'."\n";
												}
												
												if($form_page_total > 1){
													echo '</optgroup>'."\n";
												}
											}
										?>
									</select>
									<select class="select medium" id="ls_select_field_rule_lookup" name="ls_select_field_rule_lookup" autocomplete="off" style="display: none">
										<option value=""></option>
										<?php
											for ($i=1; $i <= $form_page_total ; $i++) { 
												if($form_page_total > 1){
													echo '<optgroup label="Page '.$i.'">'."\n";
												}

												$current_page_fields = array();
												$current_page_fields = $all_fields_array[$i];
												
												foreach ($current_page_fields as $element_id => $value) {

													$element_title = $value['element_title'];
													echo '<option value="'.$element_id.'">'.$element_title.'</option>'."\n";
												}
												
												if($form_page_total > 1){
													echo '</optgroup>'."\n";
												}
											}
										?>
									</select>
									<select id="ls_fields_lookup" name="ls_fields_lookup" autocomplete="off" class="element select condition_fieldname" style="width: 260px;display:none">
										<?php
											foreach ($field_labels as $element_name => $element_label) {
												
												if($columns_type[$element_name] == 'signature' || $columns_type[$element_name] == 'file'){
													continue;
												}

												$element_label = strip_tags($element_label);
												if(strlen($element_label) > 40){
													$element_label = substr($element_label, 0, 40).'...';
												}
												
												echo "<option value=\"{$element_name}\">{$element_label}</option>\n";
											}
										?>
									</select>
									<ul id="ls_field_rules_group">
										<?php
											if(!empty($logic_elements_array)){

												foreach ($logic_elements_array as $element_id => $value) {
													
													$element_title 		 = $value['element_title'];
													$element_position 	 = $value['element_position'];
													$element_page_number = $value['element_page_number'];
													$rule_show_hide		 = $value['rule_show_hide'];
													$rule_all_any		 = $value['rule_all_any'];
													
													$jquery_data_code .= "\$(\"#lifieldrule_{$element_id}\").data('rule_properties',{\"element_id\": {$element_id},\"rule_show_hide\":\"{$rule_show_hide}\",\"rule_all_any\":\"{$rule_all_any}\"});\n";
												?>

													<li id="lifieldrule_<?php echo $element_id; ?>">
														<table width="100%" cellspacing="0">
															<thead>
																<tr>
																	<td title="Field #<?php echo $element_position; ?> on Page <?php echo $element_page_number; ?>">
																		<strong title="Field #<?php echo $element_position; ?> on Page <?php echo $element_page_number; ?>"><?php echo $element_title; ?></strong><a class="delete_lifieldrule" id="deletelifieldrule_<?php echo $element_id; ?>" href="#"><img src="images/icons/52_blue_16.png"></a>
																	</td>
																</tr>
															</thead>
															<tbody>
																<tr>
																	<td>
																		<h6>
																			<img src="images/icons/arrow_right_blue.png" style="vertical-align: top" />
																			<select style="margin-left: 5px;margin-right: 5px" name="fieldruleshowhide_<?php echo $element_id; ?>" id="fieldruleshowhide_<?php echo $element_id; ?>" class="element select rule_show_hide">
																				<option value="show" <?php if($rule_show_hide == 'show'){ echo 'selected="selected"'; } ?>>Show</option>
																				<option value="hide" <?php if($rule_show_hide == 'hide'){ echo 'selected="selected"'; } ?>>Hide</option>
																			</select> this field if 
																			<select style="margin-left: 5px;margin-right: 5px" name="fieldruleallany_<?php echo $element_id; ?>" id="fieldruleallany_<?php echo $element_id; ?>" class="element select rule_all_any">
																				<option value="all" <?php if($rule_all_any == 'all'){ echo 'selected="selected"'; } ?>>all</option>
																				<option value="any" <?php if($rule_all_any == 'any'){ echo 'selected="selected"'; } ?>>any</option>
																			</select> of the following conditions match: 
																		</h6>
																		<ul class="ls_field_rules_conditions">
																			<?php
																				$current_element_conditions = array();
																				$current_element_conditions = $logic_conditions_array[$element_id];

																				$i = 1;
																				foreach ($current_element_conditions as $value) {
																					$condition_element_name = $value['element_name'];
																					$rule_condition 		= $value['rule_condition'];
																					$rule_keyword 			= htmlspecialchars($value['rule_keyword'],ENT_QUOTES);

																					$field_element_type = $columns_type[$value['element_name']];
											
																					if($field_element_type == 'matrix'){
																						//if this is matrix field which allow multiselect, change the type to checkbox
																						$temp = array();
																						$temp = explode('_', $condition_element_name);
																						$matrix_element_id = $temp[1];

																						if(in_array($matrix_element_id, $matrix_checkboxes_id_array)){
																							$field_element_type = 'checkbox';
																						}
																					}else if($field_element_type == 'time'){
																						//there are several variants of time fields, we need to make it specific
																						$temp = array();
																						$temp = explode('_', $condition_element_name);
																						$time_element_id = $temp[1];

																						if(!empty($time_field_properties[$time_element_id]['showsecond']) && !empty($time_field_properties[$time_element_id]['24hour'])){
																							$field_element_type = 'time_showsecond24hour';
																						}else if(!empty($time_field_properties[$time_element_id]['showsecond']) && empty($time_field_properties[$time_element_id]['24hour'])){
																							$field_element_type = 'time_showsecond';
																						}else if(empty($time_field_properties[$time_element_id]['showsecond']) && !empty($time_field_properties[$time_element_id]['24hour'])){
																							$field_element_type = 'time_24hour';
																						}

																					}

																					$jquery_data_code .= "\$(\"#lifieldrule_{$element_id}_{$i}\").data('rule_condition',{\"target_element_id\": {$element_id},\"element_name\":\"{$condition_element_name}\",\"condition\":\"{$rule_condition}\",\"keyword\": \"{$rule_keyword}\"});\n";

																					$condition_date_class = '';
																					$time_hour   = '';
																					$time_minute = '';
																					$time_second = '';
																					$time_ampm   = 'AM';
																					
																					if(in_array($field_element_type, array('money','number'))){
																						$condition_text_display = 'display:none';
																						$condition_number_display = '';
																						$condition_date_display = 'display:none';
																						$condition_time_display = 'display:none';
																						$condition_checkbox_display = 'display:none';
																						$condition_keyword_display = '';
																					}else if(in_array($field_element_type, array('date','europe_date'))){
																						$condition_text_display = 'display:none';
																						$condition_number_display = 'display:none';
																						$condition_date_display = '';
																						$condition_time_display = 'display:none';
																						$condition_checkbox_display = 'display:none';
																						$condition_keyword_display = '';
																						$condition_date_class = 'class="condition_date"';
																					}else if(in_array($field_element_type, array('time','time_showsecond','time_24hour','time_showsecond24hour'))){
																						$condition_text_display = 'display:none';
																						$condition_number_display = 'display:none';
																						$condition_date_display = '';
																						$condition_time_display = '';
																						$condition_checkbox_display = 'display:none';
																						$condition_keyword_display = 'display:none';
																						$condition_date_class = '';

																						if(!empty($rule_keyword)){
																							$exploded = array();
																							$exploded = explode(':', $rule_keyword);

																							$time_hour   = $exploded[0];
																							$time_minute = $exploded[1];
																							$time_second = $exploded[2];
																							$time_ampm   = strtoupper($exploded[3]); 
																						}
																						
																						//show or hide the second and AM/PM
																						$condition_second_display = '';
																						$condition_ampm_display   = '';
																						
																						if($field_element_type == 'time'){
																							$condition_second_display = 'display:none';
																						}else if($field_element_type == 'time_24hour'){
																							$condition_second_display = 'display:none';
																							$condition_ampm_display   = 'display:none';
																						}else if($field_element_type == 'time_showsecond24hour'){
																							$condition_ampm_display   = 'display:none';
																						} 
																					}else if($field_element_type == 'file'){
																						$condition_text_display = 'display:none';
																						$condition_number_display = 'display:none';
																						$condition_date_display = 'display:none';
																						$condition_time_display = 'display:none';
																						$condition_checkbox_display = 'display:none';
																						$condition_keyword_display = '';
																					}else if($field_element_type == 'checkbox'){
																						$condition_text_display = 'display:none';
																						$condition_number_display = 'display:none';
																						$condition_date_display = 'display:none';
																						$condition_time_display = 'display:none';
																						$condition_checkbox_display = '';
																						$condition_keyword_display = 'display:none';
																					}else{
																						$condition_text_display = '';
																						$condition_number_display = 'display:none';
																						$condition_date_display = 'display:none';
																						$condition_time_display = 'display:none';
																						$condition_checkbox_display = 'display:none';
																						$condition_keyword_display = '';
																					}
																			?>
																			
																				<li id="lifieldrule_<?php echo $element_id.'_'.$i; ?>" <?php echo $condition_date_class; ?>>
																					<select id="conditionfield_<?php echo $element_id.'_'.$i; ?>" name="conditionfield_<?php echo $element_id.'_'.$i; ?>" autocomplete="off" class="element select condition_fieldname" style="width: 260px;">
																						<?php
																							foreach ($field_labels as $element_name => $element_label) {
																								
																								if($columns_type[$element_name] == 'signature' || $columns_type[$element_name] == 'file'){
																									continue;
																								}

																								$element_label = strip_tags($element_label);
																								if(strlen($element_label) > 40){
																									$element_label = substr($element_label, 0, 40).'...';
																								}
																								
																								if($condition_element_name == $element_name){
																									$selected_tag = 'selected="selected"';
																								}else{
																									$selected_tag = '';
																								}

																								echo "<option {$selected_tag} value=\"{$element_name}\">{$element_label}</option>\n";
																							}
																						?>
																					</select>
																					<select name="conditiontext_<?php echo $element_id.'_'.$i; ?>" id="conditiontext_<?php echo $element_id.'_'.$i; ?>" class="element select condition_text" style="width: 120px;<?php echo $condition_text_display; ?>">
																						<option <?php if($value['rule_condition'] == 'is'){ echo 'selected="selected"'; } ?> value="is">Is</option>
																						<option <?php if($value['rule_condition'] == 'is_not'){ echo 'selected="selected"'; } ?> value="is_not">Is Not</option>
																						<option <?php if($value['rule_condition'] == 'begins_with'){ echo 'selected="selected"'; } ?> value="begins_with">Begins with</option>
																						<option <?php if($value['rule_condition'] == 'ends_with'){ echo 'selected="selected"'; } ?> value="ends_with">Ends with</option>
																						<option <?php if($value['rule_condition'] == 'contains'){ echo 'selected="selected"'; } ?> value="contains">Contains</option>
																						<option <?php if($value['rule_condition'] == 'not_contain'){ echo 'selected="selected"'; } ?> value="not_contain">Does not contain</option>
																					</select>
																					<select name="conditionnumber_<?php echo $element_id.'_'.$i; ?>" id="conditionnumber_<?php echo $element_id.'_'.$i; ?>" class="element select condition_number" style="width: 120px;<?php echo $condition_number_display; ?>">
																						<option <?php if($value['rule_condition'] == 'is'){ echo 'selected="selected"'; } ?> value="is">Is</option>
																						<option <?php if($value['rule_condition'] == 'less_than'){ echo 'selected="selected"'; } ?> value="less_than">Less than</option>
																						<option <?php if($value['rule_condition'] == 'greater_than'){ echo 'selected="selected"'; } ?> value="greater_than">Greater than</option>
																					</select>
																					<select name="conditiondate_<?php echo $element_id.'_'.$i; ?>" id="conditiondate_<?php echo $element_id.'_'.$i; ?>" class="element select condition_date" style="width: 120px;<?php echo $condition_date_display; ?>">
																						<option <?php if($value['rule_condition'] == 'is'){ echo 'selected="selected"'; } ?> value="is">Is</option>
																						<option <?php if($value['rule_condition'] == 'is_before'){ echo 'selected="selected"'; } ?> value="is_before">Is Before</option>
																						<option <?php if($value['rule_condition'] == 'is_after'){ echo 'selected="selected"'; } ?> value="is_after">Is After</option>
																					</select>
																					<select name="conditioncheckbox_<?php echo $element_id.'_'.$i; ?>" id="conditioncheckbox_<?php echo $element_id.'_'.$i; ?>" class="element select condition_checkbox" style="width: 120px;<?php echo $condition_checkbox_display; ?>">
																						<option <?php if($value['rule_condition'] == 'is_one'){ echo 'selected="selected"'; } ?> value="is_one">Is Checked</option>
																						<option <?php if($value['rule_condition'] == 'is_zero'){ echo 'selected="selected"'; } ?> value="is_zero">Is Empty</option>
																					</select> 
																					<span name="conditiontime_<?php echo $element_id.'_'.$i; ?>" id="conditiontime_<?php echo $element_id.'_'.$i; ?>" class="condition_time" style="<?php echo $condition_time_display; ?>">
																						<input name="conditiontimehour_<?php echo $element_id.'_'.$i; ?>" id="conditiontimehour_<?php echo $element_id.'_'.$i; ?>" type="text" class="element text conditiontime_input" maxlength="2" size="2" value="<?php echo $time_hour; ?>" placeholder="HH"> : 
																						<input name="conditiontimeminute_<?php echo $element_id.'_'.$i; ?>" id="conditiontimeminute_<?php echo $element_id.'_'.$i; ?>" type="text" class="element text conditiontime_input" maxlength="2" size="2" value="<?php echo $time_minute; ?>" placeholder="MM">  
																						<span class="conditiontime_second" style="<?php echo $condition_second_display; ?>"> : <input name="conditiontimesecond_<?php echo $element_id.'_'.$i; ?>" id="conditiontimesecond_<?php echo $element_id.'_'.$i; ?>" type="text" class="element text conditiontime_input" maxlength="2" size="2" value="<?php echo $time_second; ?>" placeholder="SS"> </span>
																						<select class="element select conditiontime_ampm conditiontime_input" name="conditiontimeampm_<?php echo $element_id.'_'.$i; ?>" id="conditiontimeampm_<?php echo $element_id.'_'.$i; ?>" style="<?php echo $condition_ampm_display; ?>">
																							<option <?php if($time_ampm == 'AM'){ echo 'selected="selected"'; } ?> value="AM">AM</option>
																							<option <?php if($time_ampm == 'PM'){ echo 'selected="selected"'; } ?> value="PM">PM</option>
																						</select>
																					</span>
																					<input type="text" class="element text condition_keyword" value="<?php echo $rule_keyword; ?>" id="conditionkeyword_<?php echo $element_id.'_'.$i; ?>" name="conditionkeyword_<?php echo $element_id.'_'.$i; ?>" style="<?php echo $condition_keyword_display; ?>">
																					<input type="hidden" value="" class="rule_datepicker" name="datepicker_<?php echo $element_id.'_'.$i; ?>" id="datepicker_<?php echo $element_id.'_'.$i; ?>">
								 		 											<span style="display:none"><img id="datepickimg_<?php echo $element_id.'_'.$i; ?>" alt="Pick date." src="images/icons/calendar.png" class="trigger condition_date_trigger" style="vertical-align: top; cursor: pointer" /></span>
																					<a href="#" id="deletecondition_<?php echo $element_id.'_'.$i; ?>" name="deletecondition_<?php echo $element_id.'_'.$i; ?>" class="a_delete_condition"><img src="images/icons/51_blue_16.png" /></a>
																				</li>
																			
																			<?php 
																					$i++;
																				} 
																			?>

																			<li class="ls_add_condition">
																				<a href="#" id="addcondition_<?php echo $element_id; ?>" class="a_add_condition"><img src="images/icons/49_blue_16.png" /></a>
																			</li>
																		</ul>
																	</td>
																</tr>
															</tbody>
														</table>
													</li>

												
												<?php
													
												}
											}
										?>	
									</ul>
								</div>
							</div>
						</li>
						<li>&nbsp;</li>
						<li>
							<div id="ls_box_page_rules" class="ns_box_main gradient_red">
								<div class="ns_box_title">
									<input type="checkbox" value="1" class="checkbox" id="logic_page_enable" name="logic_page_enable" <?php if(!empty($logic_page_enable)){ echo 'checked="checked"'; } ?>>
									<label for="logic_page_enable" class="choice">Enable Rules to Skip Pages</label>
									<img class="helpmsg" src="images/icons/68_red.png" style="vertical-align: top" title="Enable this option to allow users to jump into the success page or go to any specific page based on their choices. Useful when you have multipage form and need to display different set of pages based on user choices."/>
								</div>
								<div class="ls_box_content" <?php if(empty($logic_page_enable)){ echo 'style="display: none"'; } ?>>
									
									<?php if($form_page_total <= 1){ ?>
									<label style="color: #BD3D20" class="description">Page rules unavailable! <br>You need to add one or more pages into your form.</label>
									<?php } else{ ?>

									<label class="description" for="ls_select_field_rule" style="margin-top: 2px">
										Select Destination Page
									</label>
									<select class="select medium" id="ls_select_page_rule" name="ls_select_page_rule" autocomplete="off">
										<option value=""></option>
										<?php
											foreach ($all_page_labels as $page_id=>$page_title) {
												
												if(!empty($all_logic_pages_id)){
														if(in_array($page_id, $all_logic_pages_id)){
															continue;
														}
												}
												
												echo "<option value=\"{$page_id}\">{$page_title}</option>";
											}
										?>
									</select>
									<select class="select medium" id="ls_select_page_rule_lookup" name="ls_select_page_rule_lookup" autocomplete="off" style="display: none">
										<option value=""></option>
										<?php
											foreach ($all_page_labels as $page_id=>$page_title) {
												echo "<option value=\"{$page_id}\">{$page_title}</option>";
											}
										?>
									</select>
									<ul id="ls_page_rules_group">
										<?php
											if(!empty($logic_pages_array)){

												foreach ($logic_pages_array as $page_id => $value) {
													if(is_numeric($page_id)){
														$page_title = 'Page '.$page_id;
													}else{
														$page_title = ucfirst($page_id).' Page';
													}

													$page_id 	  = 'page'.$page_id;
													$rule_all_any = $value['rule_all_any'];
													
													$jquery_data_code .= "\$(\"#lipagerule_{$page_id}\").data('rule_properties',{\"page_id\": \"{$page_id}\",\"rule_all_any\":\"{$rule_all_any}\"});\n";
												?>

													<li id="lipagerule_<?php echo $page_id; ?>">
														<table width="100%" cellspacing="0">
															<thead>
																<tr>
																	<td>
																		<strong><?php echo $page_title; ?></strong><a class="delete_lipagerule" id="deletelipagerule_<?php echo $page_id; ?>" href="#"><img src="images/icons/52_red_16.png"></a>
																	</td>
																</tr>
															</thead>
															<tbody>
																<tr>
																	<td>
																		<h6>
																			<img src="images/icons/arrow_right_red.png" style="vertical-align: top" />
																			 Go to this page if 
																			<select style="margin-left: 5px;margin-right: 5px" name="pageruleallany_<?php echo $page_id; ?>" id="pageruleallany_<?php echo $page_id; ?>" class="element select rule_all_any">
																				<option value="all" <?php if($rule_all_any == 'all'){ echo 'selected="selected"'; } ?>>all</option>
																				<option value="any" <?php if($rule_all_any == 'any'){ echo 'selected="selected"'; } ?>>any</option>
																			</select> of the following conditions match: 
																		</h6>
																		<ul class="ls_page_rules_conditions">
																			<?php
																				$current_element_conditions = array();
																				$clean_page_id = substr($page_id, 4);
																				$current_element_conditions = $page_logic_conditions_array[$clean_page_id];

																				$i = 1;
																				foreach ($current_element_conditions as $value) {
																					$condition_element_name = $value['element_name'];
																					$rule_condition 		= $value['rule_condition'];
																					$rule_keyword 			= htmlspecialchars($value['rule_keyword'],ENT_QUOTES);

																					$field_element_type = $columns_type[$value['element_name']];
											
																					if($field_element_type == 'matrix'){
																						//if this is matrix field which allow multiselect, change the type to checkbox
																						$temp = array();
																						$temp = explode('_', $condition_element_name);
																						$matrix_element_id = $temp[1];

																						if(in_array($matrix_element_id, $matrix_checkboxes_id_array)){
																							$field_element_type = 'checkbox';
																						}
																					}else if($field_element_type == 'time'){
																						//there are several variants of time fields, we need to make it specific
																						$temp = array();
																						$temp = explode('_', $condition_element_name);
																						$time_element_id = $temp[1];

																						if(!empty($time_field_properties[$time_element_id]['showsecond']) && !empty($time_field_properties[$time_element_id]['24hour'])){
																							$field_element_type = 'time_showsecond24hour';
																						}else if(!empty($time_field_properties[$time_element_id]['showsecond']) && empty($time_field_properties[$time_element_id]['24hour'])){
																							$field_element_type = 'time_showsecond';
																						}else if(empty($time_field_properties[$time_element_id]['showsecond']) && !empty($time_field_properties[$time_element_id]['24hour'])){
																							$field_element_type = 'time_24hour';
																						}

																					}

																					$jquery_data_code .= "\$(\"#lipagerule_{$page_id}_{$i}\").data('rule_condition',{\"target_page_id\": \"{$page_id}\",\"element_name\":\"{$condition_element_name}\",\"condition\":\"{$rule_condition}\",\"keyword\": \"{$rule_keyword}\"});\n";

																					$condition_date_class = '';
																					$time_hour   = '';
																					$time_minute = '';
																					$time_second = '';
																					$time_ampm   = 'AM';
																					
																					if(in_array($field_element_type, array('money','number'))){
																						$condition_text_display = 'display:none';
																						$condition_number_display = '';
																						$condition_date_display = 'display:none';
																						$condition_time_display = 'display:none';
																						$condition_checkbox_display = 'display:none';
																						$condition_keyword_display = '';
																					}else if(in_array($field_element_type, array('date','europe_date'))){
																						$condition_text_display = 'display:none';
																						$condition_number_display = 'display:none';
																						$condition_date_display = '';
																						$condition_time_display = 'display:none';
																						$condition_checkbox_display = 'display:none';
																						$condition_keyword_display = '';
																						$condition_date_class = 'class="condition_date"';
																					}else if(in_array($field_element_type, array('time','time_showsecond','time_24hour','time_showsecond24hour'))){
																						$condition_text_display = 'display:none';
																						$condition_number_display = 'display:none';
																						$condition_date_display = '';
																						$condition_time_display = '';
																						$condition_checkbox_display = 'display:none';
																						$condition_keyword_display = 'display:none';
																						$condition_date_class = '';

																						if(!empty($rule_keyword)){
																							$exploded = array();
																							$exploded = explode(':', $rule_keyword);

																							$time_hour   = $exploded[0];
																							$time_minute = $exploded[1];
																							$time_second = $exploded[2];
																							$time_ampm   = strtoupper($exploded[3]); 
																						}
																						
																						//show or hide the second and AM/PM
																						$condition_second_display = '';
																						$condition_ampm_display   = '';
																						
																						if($field_element_type == 'time'){
																							$condition_second_display = 'display:none';
																						}else if($field_element_type == 'time_24hour'){
																							$condition_second_display = 'display:none';
																							$condition_ampm_display   = 'display:none';
																						}else if($field_element_type == 'time_showsecond24hour'){
																							$condition_ampm_display   = 'display:none';
																						} 
																					}else if($field_element_type == 'file'){
																						$condition_text_display = 'display:none';
																						$condition_number_display = 'display:none';
																						$condition_date_display = 'display:none';
																						$condition_time_display = 'display:none';
																						$condition_checkbox_display = 'display:none';
																						$condition_keyword_display = '';
																					}else if($field_element_type == 'checkbox'){
																						$condition_text_display = 'display:none';
																						$condition_number_display = 'display:none';
																						$condition_date_display = 'display:none';
																						$condition_time_display = 'display:none';
																						$condition_checkbox_display = '';
																						$condition_keyword_display = 'display:none';
																					}else{
																						$condition_text_display = '';
																						$condition_number_display = 'display:none';
																						$condition_date_display = 'display:none';
																						$condition_time_display = 'display:none';
																						$condition_checkbox_display = 'display:none';
																						$condition_keyword_display = '';
																					}
																			?>
																			
																				<li id="lipagerule_<?php echo $page_id.'_'.$i; ?>" <?php echo $condition_date_class; ?>>
																					<select id="conditionpage_<?php echo $page_id.'_'.$i; ?>" name="conditionpage_<?php echo $page_id.'_'.$i; ?>" autocomplete="off" class="element select condition_fieldname" style="width: 260px;">
																						<?php
																							foreach ($field_labels as $element_name => $element_label) {
																								
																								if($columns_type[$element_name] == 'signature' || $columns_type[$element_name] == 'file'){
																									continue;
																								}

																								$element_label = htmlspecialchars(strip_tags($element_label));
																								if(strlen($element_label) > 40){
																									$element_label = substr($element_label, 0, 40).'...';
																								}
																								
																								if($condition_element_name == $element_name){
																									$selected_tag = 'selected="selected"';
																								}else{
																									$selected_tag = '';
																								}

																								echo "<option {$selected_tag} value=\"{$element_name}\">{$element_label}</option>\n";
																							}
																						?>
																					</select>
																					<select name="conditiontext_<?php echo $page_id.'_'.$i; ?>" id="conditiontext_<?php echo $page_id.'_'.$i; ?>" class="element select condition_text" style="width: 120px;<?php echo $condition_text_display; ?>">
																						<option <?php if($value['rule_condition'] == 'is'){ echo 'selected="selected"'; } ?> value="is">Is</option>
																						<option <?php if($value['rule_condition'] == 'is_not'){ echo 'selected="selected"'; } ?> value="is_not">Is Not</option>
																						<option <?php if($value['rule_condition'] == 'begins_with'){ echo 'selected="selected"'; } ?> value="begins_with">Begins with</option>
																						<option <?php if($value['rule_condition'] == 'ends_with'){ echo 'selected="selected"'; } ?> value="ends_with">Ends with</option>
																						<option <?php if($value['rule_condition'] == 'contains'){ echo 'selected="selected"'; } ?> value="contains">Contains</option>
																						<option <?php if($value['rule_condition'] == 'not_contain'){ echo 'selected="selected"'; } ?> value="not_contain">Does not contain</option>
																					</select>
																					<select name="conditionnumber_<?php echo $page_id.'_'.$i; ?>" id="conditionnumber_<?php echo $page_id.'_'.$i; ?>" class="element select condition_number" style="width: 120px;<?php echo $condition_number_display; ?>">
																						<option <?php if($value['rule_condition'] == 'is'){ echo 'selected="selected"'; } ?> value="is">Is</option>
																						<option <?php if($value['rule_condition'] == 'less_than'){ echo 'selected="selected"'; } ?> value="less_than">Less than</option>
																						<option <?php if($value['rule_condition'] == 'greater_than'){ echo 'selected="selected"'; } ?> value="greater_than">Greater than</option>
																					</select>
																					<select name="conditiondate_<?php echo $page_id.'_'.$i; ?>" id="conditiondate_<?php echo $page_id.'_'.$i; ?>" class="element select condition_date" style="width: 120px;<?php echo $condition_date_display; ?>">
																						<option <?php if($value['rule_condition'] == 'is'){ echo 'selected="selected"'; } ?> value="is">Is</option>
																						<option <?php if($value['rule_condition'] == 'is_before'){ echo 'selected="selected"'; } ?> value="is_before">Is Before</option>
																						<option <?php if($value['rule_condition'] == 'is_after'){ echo 'selected="selected"'; } ?> value="is_after">Is After</option>
																					</select>
																					<select name="conditioncheckbox_<?php echo $page_id.'_'.$i; ?>" id="conditioncheckbox_<?php echo $page_id.'_'.$i; ?>" class="element select condition_checkbox" style="width: 120px;<?php echo $condition_checkbox_display; ?>">
																						<option <?php if($value['rule_condition'] == 'is_one'){ echo 'selected="selected"'; } ?> value="is_one">Is Checked</option>
																						<option <?php if($value['rule_condition'] == 'is_zero'){ echo 'selected="selected"'; } ?> value="is_zero">Is Empty</option>
																					</select> 
																					<span name="conditiontime_<?php echo $page_id.'_'.$i; ?>" id="conditiontime_<?php echo $page_id.'_'.$i; ?>" class="condition_time" style="<?php echo $condition_time_display; ?>">
																						<input name="conditiontimehour_<?php echo $page_id.'_'.$i; ?>" id="conditiontimehour_<?php echo $page_id.'_'.$i; ?>" type="text" class="element text conditiontime_input" maxlength="2" size="2" value="<?php echo $time_hour; ?>" placeholder="HH"> : 
																						<input name="conditiontimeminute_<?php echo $page_id.'_'.$i; ?>" id="conditiontimeminute_<?php echo $page_id.'_'.$i; ?>" type="text" class="element text conditiontime_input" maxlength="2" size="2" value="<?php echo $time_minute; ?>" placeholder="MM">  
																						<span class="conditiontime_second" style="<?php echo $condition_second_display; ?>"> : <input name="conditiontimesecond_<?php echo $page_id.'_'.$i; ?>" id="conditiontimesecond_<?php echo $page_id.'_'.$i; ?>" type="text" class="element text conditiontime_input" maxlength="2" size="2" value="<?php echo $time_second; ?>" placeholder="SS"> </span>
																						<select class="element select conditiontime_ampm conditiontime_input" name="conditiontimeampm_<?php echo $page_id.'_'.$i; ?>" id="conditiontimeampm_<?php echo $page_id.'_'.$i; ?>" style="<?php echo $condition_ampm_display; ?>">
																							<option <?php if($time_ampm == 'AM'){ echo 'selected="selected"'; } ?> value="AM">AM</option>
																							<option <?php if($time_ampm == 'PM'){ echo 'selected="selected"'; } ?> value="PM">PM</option>
																						</select>
																					</span>
																					<input type="text" class="element text condition_keyword" value="<?php echo $rule_keyword; ?>" id="conditionkeyword_<?php echo $page_id.'_'.$i; ?>" name="conditionkeyword_<?php echo $page_id.'_'.$i; ?>" style="<?php echo $condition_keyword_display; ?>">
																					<input type="hidden" value="" class="rule_datepicker" name="datepicker_<?php echo $page_id.'_'.$i; ?>" id="datepicker_<?php echo $page_id.'_'.$i; ?>">
								 		 											<span style="display:none"><img id="datepickimg_<?php echo $page_id.'_'.$i; ?>" alt="Pick date." src="images/icons/calendar.png" class="trigger condition_date_trigger" style="vertical-align: top; cursor: pointer" /></span>
																					<a href="#" id="deletecondition_<?php echo $page_id.'_'.$i; ?>" name="deletecondition_<?php echo $page_id.'_'.$i; ?>" class="a_delete_condition"><img src="images/icons/51_red_16.png" /></a>
																				</li>
																			
																			<?php 
																					$i++;
																				} 
																			?>

																			<li class="ls_add_condition">
																				<a href="#" id="addcondition_<?php echo $page_id; ?>" class="a_add_condition"><img src="images/icons/49_red_16.png" /></a>
																			</li>
																		</ul>
																	</td>
																</tr>
															</tbody>
														</table>
													</li>

												
												<?php
													
												}
											}
										?>	
									</ul>

									<?php } ?>
								</div>
							</div>
						</li>
						<!--
						<li>&nbsp;</li>
						<li>
							<div id="ls_box_notification_rules" class="ns_box_main gradient_green">
								<div class="ns_box_title">
									<input type="checkbox" value="1" class="checkbox" id="logic_notification_enable" name="logic_notification_enable">
									<label for="logic_notification_enable" class="choice">Enable Rules to Send Notification Emails</label>
									<img class="helpmsg" src="images/icons/68_green.png" style="vertical-align: top" title="Enable this option to send additional notification emails to any email address. You can customize the email content, subject, and from address based on user choices."/>
								</div>
								
							</div>
						</li>
						<li>&nbsp;</li>
						<li>
							<div id="ls_box_success_rules" class="ns_box_main gradient_green">
								<div class="ns_box_title">
									<input type="checkbox" value="1" class="checkbox" id="logic_success_enable" name="logic_success_enable">
									<label for="logic_success_enable" class="choice">Enable Rules to Customize Success Page</label>
									<img class="helpmsg" src="images/icons/68_green.png" style="vertical-align: top" title="Enable this option to display custom success page or redirect to any website address after successful form submission. This will override your default success page you create from the Form Builder."/>
								</div>
								
							</div>
						</li>
						-->			
					</ul>
					<input type="hidden" id="form_id" name="form_id" value="<?php echo $form_id; ?>">
					</form>


				</div> <!-- /end of content_body -->	
			
			</div><!-- /.post -->
		</div><!-- /#content -->
		
<div id="dialog-warning" title="Error Title" class="buttons" style="display: none">
	<img src="images/icons/warning.png" title="Warning" /> 
	<p id="dialog-warning-msg">
		Error
	</p>
</div>
 
<?php
	$footer_data =<<<EOT
<script type="text/javascript">
	$(function(){
		{$jquery_data_code}		
    });
</script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.core.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.widget.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.tabs.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.mouse.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.sortable.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.draggable.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.position.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.ui.dialog.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.effects.core.js"></script>
<script type="text/javascript" src="js/jquery-ui/ui/jquery.effects.pulsate.js"></script>
<script type="text/javascript" src="js/jquery.tools.min.js"></script>
<script type="text/javascript" src="js/datepick/jquery.datepick.js"></script>
<script type="text/javascript" src="js/logic_settings.js"></script>
EOT;

	require('includes/footer.php'); 
?>